/*
 * --COPYRIGHT--,BSD Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved. Redistribution and use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met: * Redistributions of source code must
 * retain the above copyright notice, this list of conditions and the
 * following disclaimer. * Redistributions in binary form must reproduce
 * the above copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided with
 * the distribution. * Neither the name of Texas Instruments Incorporated 
 * nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE. --/COPYRIGHT--
 */

// ******************************************************************************
// Rick Duncan
// Texas Instruments Inc.
// Feb 2015
// ******************************************************************************

#include <msp430.h>
#include "utility.h"

// no interrupts are being used here
// trap all unused vectors
#pragma vector=DAC12_VECTOR, DMA_VECTOR, USCIAB1TX_VECTOR, USCIAB1RX_VECTOR, \
		PORT1_VECTOR, PORT2_VECTOR, \
		ADC12_VECTOR, WDT_VECTOR, COMPARATORA_VECTOR, \
		TIMERA0_VECTOR, TIMERB0_VECTOR, NMI_VECTOR
__interrupt void
Trap_ISR(void)
{
}


// TIMERA1 is not used, exit if entered
#pragma vector=TIMERA1_VECTOR
__interrupt void
TimerA1(void)
{
    switch (TAIV) {
    case TAIV_TACCR1:
	break;
    case TAIV_TACCR2:
	break;
    case TAIV_TAIFG:
	break;
    }

}

// TIMERB1 is not used, exit if entered
#pragma vector=TIMERB1_VECTOR
__interrupt void
TimerB1(void)
{
    switch (TBIV) {
    case TBIV_TBCCR1:
	break;
    case TBIV_TBCCR2:
	break;
    case TBIV_TBCCR3:
	break;
    case TBIV_TBCCR4:
	break;
    case TBIV_TBCCR5:
	break;
    case TBIV_TBCCR6:
	break;
    case TBIV_TBIFG:
	break;
    }
}
